#!/bin/env ruby
# encoding: utf-8
require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'
require 'oci8'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../common/common'
require_relative '../../pages/appointments/new_appointment_request'
require_relative '../../helper/modal'
require_relative '../../module/database/OracleUtility'
require_relative '../../module/DateUtility'
require_relative '../../module/database/MongoUtility'
require_relative '../../pages/landing_appointments'
require_relative '../../pages/landing_notifications'

describe '[Story# VAR-10107: New appointment/request - Cancel button]'  do

  include DriverUtility
  include OracleUtility
  include DateUtility
  include MongoUtility


  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @common = Common.new(@driver)
    @modal = Modal.new(@driver)
    @new_appointment = NewAppointmentRequest.new(@driver)
    @landing_notifications = LandingNotifications.new(@driver)
    @landing_appointments = LandingAppointments.new(@driver)
    @modal = Modal.new(@driver)
    TITLE = "Appointments/Requests"
    @db = connectToMongoDB("var-utility")
    restoreCollection("siteSupportingVAR", "var-utility", "sites-supporting-var-exported2.json", @db)
    restoreCollection("clinical-services", "var-utility", "clinical_services_default.json", @db)
    restoreCollection("requestEligibilityCriteria", "var-utility", "requestEligibilityCriteria.json", @db)
    restoreCollection("directBookingEligibilityCriteria", "var-utility", "directSchedulingEnabled.json", @db)
    restoreCollection("custom-friendly-text", "var-utility", "facility_friendly_name.json", @db)
    @common.loginEndsOnHome(pw_redacted)
    @landing_appointments.appointment_header_element.wait_until_present(TIME_OUT_LIMIT)
  end

  after(:all) do
    @driver.close
  end

  context 'AC#VAR-10177|TC#VAR-10178: New appointment/request - Cancel button' do

    it 'should display a modal when a user is completing a new request' do
      @common.selectAddAppointmentButton("VA")
      @new_appointment.selectNewAppointmentAndSchedule(PRIMARY_CARE, "523", "523", "clerk")

      #Confirmation Modal is displayed when cancel button is selected
      @new_appointment.cancel_element.wait_until_present(TIME_OUT_LIMIT)
      @new_appointment.cancel_element.click
      @modal.modalTitle_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@modal.modalTitle_element.text).to eq "Cancel Confirmation"
      expect(@modal.content_element.text).to eq "Are you sure you want to cancel this request?"

    end

    it "should return to form when no is selected for cancel" do
      #When No is selected, user is returned to the form
      @modal.buttons_elements[1].click
      @new_appointment.type_of_care_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@new_appointment.schedule_appointment_element.text).to eq("Submit Request")

    end

    it "should cancel form when yes is selected for cancel" do
      #When Yes is selected, user is returned to the main page
      @new_appointment.cancel_element.wait_until_present(TIME_OUT_LIMIT)
      @new_appointment.cancel_element.click
      @modal.buttons_elements[0].click
      @landing_appointments.appointment_header_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@landing_appointments.appointment_header).to eq("Appointments")
    end

    it 'should display a modal when a user is completing a new appointment' do
      @common.selectAddAppointmentButton("VA")
      @new_appointment.selectNewAppointmentAndSchedule(PRIMARY_CARE, "523", "523", "direct")

      #Confirmation Modal is displayed when cancel button is selected
      @new_appointment.mutiple_clinics_element.wait_until_present(TIME_OUT_LIMIT)
      @new_appointment.cancel_element.wait_until_present(TIME_OUT_LIMIT)
      @new_appointment.cancel_element.click
      @modal.modalTitle_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@modal.modalTitle_element.text).to eq "Cancel Confirmation"
      expect(@modal.content_element.text).to eq "Are you sure you want to cancel scheduling this appointment?"

    end

    it "should return to form when no is selected for cancel" do
      #When No is selected, user is returned to the form
      @modal.buttons_elements[1].click
      @new_appointment.type_of_care_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@new_appointment.appointment_details_legend).to eq("Appointment Details")
    end

    it "should cancel form when yes is selected for cancel" do

      #When Yes is selected, user is returned to the main page
      @new_appointment.cancel_element.wait_until_present(TIME_OUT_LIMIT)
      @new_appointment.cancel_element.click
      @modal.modalTitle_element.wait_until_present(TIME_OUT_LIMIT)
      @modal.buttons_elements[0].click
      @landing_appointments.appointment_header_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@landing_appointments.appointment_header).to eq("Appointments")
    end

  end

end